;*******************************************************************
;
;	Inductance & Capacitance Meter
;
;*******************************************************************

;*******************************************************************
;
; LC002	- THIS ONE WORKS FINE WITH A WELL BEHAVED DISPLAY
;
;	Deleted  CpyBin subroutine and one call to it
;
;	Modified B2BCD to take its input directly from <AARGB0,1,2>
;
;	Modified "oscillator test" so it copies F3   to <AARGB0,1,2>
;
;	Fixed Get_Lcal so it gets the correct number
;
;	Minor adjustment to Delay100ms timing to correct frequency display
;
;	Check for oscillator too slow when measuring L or C.
;
;
;*******************************************************************
;
; LC003	- Optimised / Modified to handle "bad" displays
;
;	Removed duplicated code in LCDPutChar subroutine
;
;	Added code to fix crook display (select by jumper on B4 - 10)
;
;	Optimised L & C formatting code
;
;	Optimised "Display" subroutine
;
;	Cleaned up LCDINIT
;
;
;*******************************************************************
;
; LC004 - Deleted timer Interrupt Service Routine
;
;	Modified way oscillator "out of range" condition is detected
;
;
;*******************************************************************
;
; LC628 - LC004 code ported to 16F628 by Egbert Jarings PA0EJH.
;	Mem starts now at 0x20
;	InitIO modified , 628 PortA start's up in Analog Mode 
;	So changed to Digital Mode (CMCON)
; 
;	Display's "Calibrating" to fill up dead Display time
;	when first Powerd Up.
;
;	Changed pmsg Routine, EEADR  trick  wont work with 628,
;	PCL was always 0x00 so restart occurs. EEADR is now Etemp.
;
;	Also changed EEADR in FP routine to Etemp 
;
;	Bad Display isn't bad at all, its a Hitachi HD44780, as
;	80% of all Display's are. Adress as 2 Lines x 8 Char.
;	So LCDINIT modified for 2 x 8 Display's. (0x28 added)
;
;*******************************************************************
;
; LC005 - Cosmetic rewrite of RAM allocation from LC004
;
;	No change to address of anything - I hope
;	Identified unused RAM & marked for later removal.
;
;
;*******************************************************************
;
; LC006 - Merge LC005 and LC628
;
;	All "#ifdef" F628 parts by Egbert Jarings PA0EJH.
;	(or derived from his good work)
;	Cleaned up RAM allocation.
;	Added message re: processor type, just to verify selection
;	Included extra initialisation (2 line) command by PA0EJH
;
;*******************************************************************
;
; lc007	Changed strings to EEPROM (it's not used for anything else)
;
;	Added "error collector" code to catch "all" FP errors
;       Addded macros
;
;*******************************************************************
;
; LC_swcal.000
;	Changed to use only F628 processor
;	Used internal comparator of F628 in place of LM311
;	Switched relay directly by digital I/O
;	Implemented software calibration via constant in EEPROM
;	Re-allocated most I/O pins
;	Added output munger for LCD connections (easy to re-allocate)
;
;************************************************************************
;
; LC_da.000
;	DATELEC.FR nov 2007
;	refine the measurement duration exactly to 100ms, directly condition the L accuracy
;	Clean the code, especially the wait routine
;	use the 2nd line of the display to show frequency and L/C value
;	diffentiate error messages and test F1/F2 messages
;	Install a LED lit when measurement done
;	Install a 1k scale factor (kilo) to go higher than 83.88mH or 838.8nF ; stay on 23bits
;
;*******************************************************************
;o-----o-----o-----o-----o-----o-----o-----o-----o-----o-----o-----o
;*******************************************************************
;
;	Some frequently used code fragments
;	Use macros to make mistreaks consistently.
;

	include	<common.inc>

SWAP	macro	this,that	; Swap bytes in register file via W
	MOVF	this,w		; get this
	XORWF	that,f		; Swap using Microchip Tips'n Tricks #18
	XORWF	that,w		; 
	XORWF	that,f		; 
	MOVWF	this
	endm

#DEFINE	Xtal 40000	; valeur de l'oscillateur interne / 100Hz

Wait_us macro _DelayUS
; verifi sous MPLAB SIM et avec http://www.piclist.com/techref/piclist/codegen/delay.htm
	MOVLF	COUNT1,((_DelayUS+1273)/1280)
	MOVLF	COUNT2,((_DelayUS+1273)%1280)/5
	CALL	DelaySub
	endm

;*******************************************************************
;
;	CPU configuration
;

	MESSG		"Processor = 16F628"
	processor	16f628
	include		<p16f628.inc>
	__CONFIG        _CP_OFF & _WDT_OFF & _PWRTE_ON & _HS_OSC & _BODEN_ON & _LVP_OFF


;**********************************************************
;
;	I/O Assignments. 
; 1 = input
; 0 = output
;


#DEFINE	_TRISA	B'11110111'
				;
				; PORTA        7  6  5  4 3 2 1 0
				; TRISA      =       R  1 0 1 1 1
				; PORTA<0>   = comp1 "-" in
				; PORTA<1>   = comp2 "-" in
				; PORTA<2>   = comp1&2 "+" in
				; PORTA<3>   = comp1 out
				; PORTA<4>   = comp2 out, T0CKI in ; set to ZERO to enable count
				; PORTA<5>   = /reset
				; PORTB<6>   = Xtal
				; PORTA<7>   = Xtal


#DEFINE relay	PORTB,7		; output, 1 = energise relay
#DEFINE	LED_K	PORTB,6		; LED cathode
#DEFINE	LCD_RS	PORTB,5		; output, Display "RS"
#DEFINE	functn	links,5		; input, 0 = "Inductor"
#DEFINE	LCD_ENA	PORTB,4		; output, Display "EN"
#DEFINE	LCD_DB4	PORTB,3		; output, LCD bit 4
#DEFINE	LCD_DB5	PORTB,2		; output, LCD bit 5
#DEFINE	LCD_DB6	PORTB,1		; output, LCD bit 6
#DEFINE	LCD_DB7	PORTB,0		; output, LCD bit 7

#DEFINE	_TRISB	B'00000000'


;*******************************************************************
;
;	file register declarations: uses only registers in bank0
;	bank 0 file registers begin at 0x0c in the 16F84
;	and at 0x20 in the 16F628
;
;*******************************************************************

	cblock	0x20
;
;       Floating Point Stack and other locations used by FP.asm
;
;	FP Stack: TOS	A = 	AEXP:AARGB0:AARGB1:AARGB3:AARGB4
;			B = 	BEXP:BARGB0:BARGB1:BARGB2
;			C = 	CEXP:CARGB0:CARGB1

	AEXP			; FP.ASM 8 bit biased exponent for argument A
	AARGB0, AARGB1, AARGB2, AARGB3, AARGB4

	BEXP			; FP.ASM  8 bit biased exponent for argument B
	BARGB0, BARGB1, BARGB2

	CEXP			; 8 bit biased exponent for argument C
	CARGB0, CARGB1, CARGB3

;	TEMPB3			; FP.ASM 1 Unused byte
;	TEMPB2			; FP.ASM 1 Unused byte
	TEMPB1			; FP.ASM Used
	TEMPB0			; FP.ASM Used

	FPFLAGS			; FP.ASM floating point library exception flags
	SIGN			; FP.ASM save location for sign in MSB

	FPE			; Collect FP errors in here

	BCDbits			; Bin to BCD convert (bit count)
	BCDbytes		;                    (BCD BYTES)

	F1:2
	F2:2
	F3:2
	bcd:4			; BCD, MSD first 

	R_sign			; Holds "+" or " " (sign)

	endc

	cblock	0x70		; Common RAM, accessible in both banks

	BITS
	Ccal:2			; Ccal temporary value
	Lcal:2			; Ccal temporary value
	LCDtemp			; LCD temp
	LCDtemp2		; LCD temp
	links			; etats des jumpers sur le port B
	COUNT1			; Used by delay routines
	COUNT2

	endc

#DEFINE	kilo		BITS,0
#DEFINE	SaveCal	BITS,1




;**********************************************************
;
; RESET & INTERRUPT VERCTOR ZONE
	ORG 0x000		; processor reset vector
  	GOTO MAIN		; go to beginning of program



; PROGRAM ZONE
	ORG 0x020
MAIN	

;  Initialise Input & Output devices
	MOVLF	CMCON,B'00000110'	; select comparator mode 110 commonref with outputs on RA3 and RA4
	SetBank 1
	MOVLF	VRCON,B'00000000'	; Set Volt ref mode to OFF, and disconnect from RA2
	MOVLF	OPTION_REG,0x37	; Option register
				; Port B weak pull-up enabled
				; INTDEG Don't care
				; Count RA4/T0CKI
				; Count on falling edge
				; Prescale Timer/counter
				; divide Timer/counter by 256

	MOVLF	TRISA,_TRISA	; initialise data direction
	MOVLF	TRISB,_TRISB	; initialise data direction

	SetBank 0
	CLRB	relay		; de-energise relay
	CALL	LCDINIT	 	; INITIALIZE LCD MODULE	
	CALL	EE_RD		; Retrieve CCal integer value
	CALL	LCDhome
	SETB	LED_K	; LED OFF

;------------------------------------------------------------------
;
;	"Zero" the meter.
;
	MOVLW   Calibr-eestart	; Display's " Calibrating "
	CALL	pmsg		; to entertain the punters

;	CALL	Measure		; Dummy Run to stabilise oscillator.
	Wait_us 200000	
	Wait_us 200000	
	Wait_us 200000	
	Wait_us 200000	
	Wait_us 200000		
	CALL	Measure		; Get freq in F3
	COPY2	F3,F1		; Copy F3:2 to F1:2

	SETB	relay		; Add standard capacitor
;----------v
	CALL	LCDgotoLine2
	MOVLW	F3
	CALL	LCDPut5		; print F3 in BCD in format xxx.xx
;----------^

	Wait_us 200000	
	CALL	Measure		; Get freq in F3
	COPY2	F3,F2		; Copy F3:2 to F2:2

	CLRB	relay		; Remove standard capacitor
;----------v
	CALL	LCDPutSpace
	MOVLW	F3
	CALL	LCDPut5		; print F3 in BCD in format xxx.xx
;----------^

	Wait_us 200000	
;	CALL	Measure		; Dummy Run to stabilise oscillator.

;
;	Now we resume our regular program
;

MainLoop
	SetBank 1			; PORTB:-
	MOVLF	TRISB,_TRISB | 0x2F	; jumper data bits to read
	SetBank 0
	Wait_us 100		; Settling time  ?????
	COPY	PORTB,links	; attention PORTB est sur le bank 0
	SetBank 1
	MOVLF	TRISB,_TRISB	; restore data direction
	SetBank 0

;---------------------------------------------------------------
;
;	Take a break from regular duties to do something interesting
;

	JNB	links,0,cal_up		; Raise Ccal value

	JNB	links,1,cal_dn		; Lower Ccal value

	JNB	links,2,osc1		; Test osc without Ccal

	JNB	links,3,osc2		; Test osc with Ccal

;
;	None of the above
;

	CLRB	relay		; In case of return from osc test
	JNB	SaveCal,cont	; Time to save Ccal value (SaveCal=1 ?)
	 	; yes 
	CLRB	SaveCal	; To say we have done it
	CALL	EE_WR		; So, we better save it
	GOTO	cont		; Hi Ho, its off to work I go

;
;-------------------------------------------------------------------------
;	increment or decrement EEPROM Ccal:2 value	
;

cal_up	SETB	SaveCal	; SaveCal=1 to say Ccal "modified"
	JB	functn,Ccal_up	; 0=Inductor
	MOVLW	0x0a		; Add +10 to Lcal:2
	ADDWF	Lcal+1,f
	SKPNC
	 INCF	Lcal+0,f
	GOTO	cont

Ccal_up	MOVLW	0x0a		; Add +10 to Ccal:2
	ADDWF	Ccal+1,f
	SKPNC
	 INCF	Ccal+0,f
	GOTO	cont

cal_dn	SETB	SaveCal	; SaveCal=1 to say Ccal "modified"
	JB	functn,Ccal_dn	; 0=Inductor
	MOVLW	0xf6		; Add -10 to Lcal:2
	ADDWF	Lcal+1,f
	SKPNC	
	 INCF	Lcal+0,f
	MOVLW	0xff
	ADDWF	Lcal+0,f
	GOTO	cont

Ccal_dn	MOVLW	0xf6		; Add -10 to Ccal:2
	ADDWF	Ccal+1,f
	SKPNC	
	 INCF	Ccal+0,f
	MOVLW	0xff
	ADDWF	Ccal+0,f
	GOTO	cont		

;-------------------------------------------------------------------------
;	Measure & display osc freq for initial setup

osc2	SETB	relay		; Add Ccal
	GOTO	$+2
osc1	CLRB	relay		; remove Ccal
	CALL	Measure		; Get freq in F3
	CALL	LCDclear
	
	BTFSS	INTCON,T0IF	; Set = Counter overflow?
	  GOTO	Do_Disp
	MOVLW	ovr-eestart	; Overflow message
	CALL	pmsg
	GOTO	MainLoop

Do_Disp	
	MOVLW	Tintro-eestart	; Message TMR0 =
	CALL	pmsg
	SWAPF	F3,W
	CALL	LCDPutHexa
	MOVF	F3,W
	CALL	LCDPutHexa
	SWAPF	F3+1,W
	CALL	LCDPutHexa
	MOVF	F3+1,W
	CALL	LCDPutHexa
	CALL	LCDgotoLine2


	MOVLW	F1intro-eestart	; Message TEST F1=
	BTFSC	relay
	 MOVLW	F2intro-eestart	; Message TEST F2=
	CALL	pmsg

	MOVLW	F3
	CALL	LCDPut5		; print F3 in BCD in format xxx.xx
	MOVLW	UnitkHz-eestart	; Message TEST F2=
	CALL	pmsg

	GOTO	MainLoop

;-------------------------------------------------------------------------

cont	CALL	LCDhome
	CALL	Measure		; Measure F3 & leave it there

	BTFSS	INTCON,T0IF	; test for "too high" frequency
	  GOTO	cont2		; F > 655359Hz ?
	MOVLW	ovr-eestart	; Over range message
	CALL	pmsg
	GOTO	MainLoop

;
;	Precompute major bracketed terms cos
;	we need 'em both for all calculations
;

cont2
	; ici affichage freq F3 et passage ligne 2
	MOVLW	Fintro-eestart	; Message  F =
	CALL	pmsg

	MOVLW	F3
	CALL	LCDPut5		; print F3 in BCD in format xxx.xx
	MOVLW	UnitkHz-eestart	; Message TEST F2=
	CALL	pmsg

cont5	CALL	LCDgotoLine2

	MOVLW	Cintro-eestart	; C =
	BTFSS	functn		; 0=Inductor
	 MOVLW	Lintro-eestart	; L =
	CALL	pmsg

	MOVF	F3,w		; test for "too low" frequency
	BNZ	cont6		; F < 2560Hz ?   F3=00xx ?
	MOVLW	blank-eestart	; too low ==> blank field
	CALL	pmsg
	GOTO	MainLoop

cont6	CLRF	FPE		; Declare "error free"
	CALL	F1_F2		; Calculate A=(F1/F2)^2-1
	CALL	F1_F3		; Calculate A=(F1/F3)^2-1 ; B=(F1/F2)^2-1
	MOVF	FPE,f		; Any FP errors?
	BNZ	complain1

	BTFSS	functn		; 0=Inductor
	 GOTO	Do_Ind

;	OK, we've been told it's a capacitor
Do_Cap	CALL	C_calc		; result in 8 digits bcd:4
	MOVF	FPE,f		; Any FP errors?
	BNZ	complain2

	CALL	C_disp
	GOTO	MainLoop

;	Now, they reckon it's a @#$*! inductor
Do_Ind	CALL	L_calc		; result in 8 digits bcd:4
	MOVF	FPE,f		; Any FP errors?
	BNZ	complain2
	
	CALL	L_disp
	GOTO	MainLoop

;	Got a Floating Point Error of some sort
complain1
	MOVLW	FPerr1-eestart	; Over Range
	GOTO	$+2
complain2
	MOVLW	FPerr2-eestart	; Over Range
	CALL	pmsg

	SWAPF	FPFLAGS,W
	CALL	LCDPutHexa
	MOVF	FPFLAGS,W
	CALL	LCDPutHexa
	GOTO	MainLoop

;**********************************************************
;
;	Print String addressed by W
;	Note: Strings are in EEPROM
;	We do a lotta bank switching here.

pmsg	SetBank 1
	MOVWF	EEADR		; pointer

pm1	SETB     EECON1,RD       ; EE Read
        MOVF    EEDATA,W        ; W = EEDATA, affects Z bit
        SetBank 0			; Does not change Z bit
 
	BTFSC	STATUS,Z	; ZERO = All done
	 return			; so quit

	CALL	LCDPutChar		; Byte -> display

	SetBank 1
	INCF    EEADR,F         ; bump address
	GOTO	pm1
	

;**********************************************************
;
;	Delay
;

DelaySub	; wait 12+5*(COUNT2-1)+1280*(COUNT1-1) = 1280*COUNT2+5*COUNT1-1273
		; en comptant les 4 cycles pour charger COUNT1 et COUNT2, le call et le return
		; min=12 (01:01)    max = 327000 cycles (00:00)
	DECFSZ	COUNT2,F
	 GOTO	$+2
	DECFSZ	COUNT1,F
	 GOTO	DelaySub
	RETLW	0

;**********************************************************
;
;
; 	LCD routines
;
;
;
; INITIALISE LCD MODULE 4 BIT MODE 

LCDINIT	CLRB	LCD_RS		; REGISTER SELECT LOW, command register
	CLRB	LCD_ENA		; ENABLE LINE LOW
 	Wait_us 100000		; WAIT FOR LCD MODULE HARDWARE RESET
 
	MOVLW	0x03		; 1
	call	LCDPutNibble
	Wait_us 5000		; spec HD44780=4.1ms

	MOVLW	0x03		; 2
	call	LCDPutNibble
	Wait_us 200		; spec HD44780=100us

	MOVLW	0x03		; 3
	call	LCDPutNibble

	MOVLW	0x02		; Fn set 4 bits
	call	LCDPutNibble

	MOVLW	0x0C		; 0x0C DISPLAY ON
	CALL	LCDPutCommand

	MOVLW	0x28		; DISPLAY 2 Line , 5x7 Dot's
	CALL	LCDPutCommand
	
	MOVLW	0x06		; 0x06 ENTRY MODE SET
	CALL	LCDPutCommand

;
;	standard commands
;

LCDclear
	MOVLW	0x01		; CLEAR DISPLAY
	GOTO	LCDPutCommand	; LONGER DELAY NEEDED WHEN CLEARING DISPLAY

LCDhome	MOVLW	0x02		; HOME DISPLAY
	GOTO	LCDPutCommand

LCDgotoLine2
	MOVLW	0xC0		; Set RAM address = 0x40, start of second line
	GOTO	LCDPutCommand

; 	standard characters 
;

LCDPutDP	; Print DP
	MOVLW	'.'
	GOTO	LCDPutChar	; Return in LCDPutChar

LCDPutSpace	; PRINT A SPACE
	MOVLW	0x20
	GOTO	LCDPutChar	; Return in LCDPutChar

; transcode en HEXA+ ASCII le contenu de WREG
;ACC=           00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 10 11 12 13 14 ...
;sublw 9        09 08 07 06 05 04 03 02 01 00 FF FE FD FC FB FA
;carry=          1  1  1  1  1  1  1  1  1  1  0  0  0  0  0  0
;addlw F9                                     F8 F7 F6 F5 F4 F3
;sublw 39       30 31 32 33 34 35 36 37 38 39 41 42 43 44 45 46 47 48 49 4A 4B ...
LCDPutHexa
	ANDLW	0x0F		; keep low nibble
	SUBLW	0x09		; W=9-W, compare  9
	SKPC	
	  ADDLW	0xF9		; si c'est >=10, ajoute 0xF9
	SUBLW	0x39		; W=39-W, et soustrait 0x39 toujours
	GOTO	LCDPutChar
	
LCDPutBCD	; display low nibble in BCD
	ANDLW	0x0F
	ADDLW	0x30
	GOTO	LCDPutChar

;
; Write to display and wait
;
;

LCDPutCommand			; SENDS DATA TO LCD DISPLAY MODULE (4 BIT MODE)
	MOVWF	LCDtemp		; Store in temporary location
	CLRB	LCD_RS		; Select command register
	GOTO	LCDPutByte

LCDPutChar	; Put a byte to display
	; 00 to 1F sent as a command
	; 20 to 7F sent as a data
	; 80 to FF sent as a command ; set RAM address : 80 for beg of firat line, C0 for beg of 2nd line

	MOVWF	LCDtemp		; Store in temporary location
	CLRB	LCD_RS		; SELECT COMMAND REGISTER
	ANDLW	0xE0
	BZ	LCDPutByte	; si W=000x xxxx, c'est une commande ==> RS=0
	MOVF	LCDtemp,W
	ANDLW	0x80
	BNZ	LCDPutByte	; si W=1xxx xxxx, c'est une commande ==> RS=0
				; sinon c'est un data ==> RS=1
	SETB	LCD_RS		; Select data register

LCDPutByte
	SWAPF	LCDtemp,W	; SWAP UPPER AND LOWER NIBBLES (4 BIT MODE)
	CALL	LCDPutNibble	; write high nibble

	MOVF	LCDtemp,W	; GET CHAR AGAIN 
	CALL	LCDPutNibble	; write low nibble

	MOVF	LCDtemp,W	; si "clear" ou "home", il faut attendre >1700s
	ANDLW	0xFC
	SKPZ
	  RETLW	0	
	Wait_us 2000		; wait 2ms (spec HD44780 = 1700us)
	RETLW	0

LCDPutNibble
	MOVWF	LCDtemp2		; Save nibble

	BTFSS	LCDtemp2,0	; copy LSbit in LCD_DB4
	 CLRB	LCD_DB4
	BTFSC	LCDtemp2,0
	 SETB	LCD_DB4

	BTFSS	LCDtemp2,1
	 CLRB	LCD_DB5
	BTFSC	LCDtemp2,1
	 SETB	LCD_DB5

	BTFSS	LCDtemp2,2
	 CLRB	LCD_DB6
	BTFSC	LCDtemp2,2
	 SETB	LCD_DB6

	BTFSS	LCDtemp2,3	; copy MSbit in LCD_DB7
	 CLRB	LCD_DB7
	BTFSC	LCDtemp2,3
	 SETB	LCD_DB7

	SETB	LCD_ENA		; ENA HIGH
				; stay 1s (spec HD44780 = 480ns), cannot do quicker !
	CLRB	LCD_ENA		; ENA LOW 
	Wait_us 50		; wait 50s (spec HD44780 = 40us)
	RETURN

;******************************************************************
;
;	Convert 24-bit binary number at <AARGB0,1,2> into a 8 digits bcd number
;	at [bcd0:bcd1:bcd2:bcd3]. Uses Mike Keitz's procedure for handling bcd 
;	adjust; Modified Microchip AN526 for 24-bits.
;

B2BCD   MOVLF	BCDbits,.24	; 24-bits make cycle counter
        CLRF	bcd+0		; clear result area
        CLRF	bcd+1
        CLRF	bcd+2
        CLRF	bcd+3

b2bcd2  MOVLF	FSR,bcd		; make pointer
        MOVLF	BCDbytes,.4

; Mike's routine:

b2bcd3  MOVLW	0x33        ; BCD adjust    
        ADDWF	INDF,f          ; add to both nibbles
        BTFSC	INDF,3          ; test if low result > 7
         ANDLW	0xf0            ; low result >7 so take the 3 out
        BTFSC	INDF,7          ; test if high result > 7
         ANDLW	0x0f            ; high result > 7 so ok
        SUBWF	INDF,f          ; any results <= 7, subtract back
        INCF	FSR,f           ; point to next
        DECFSZ	BCDbytes,f
         GOTO	b2bcd3
        
        RLF	AARGB2,f	; get another bit from MSB
        RLF	AARGB1,f
        RLF	AARGB0,f

        RLF	bcd+3,f		; put it into bcd lsb
        RLF	bcd+2,f
        RLF	bcd+1,f
        RLF	bcd+0,f

        DECFSZ	BCDbits,f	; all done?
         GOTO	b2bcd2          ; no, loop
        RETURN			; yes

;**********************************************************
;
;	Measure Frequency with TMR0
;	with a gate of 100ms and prescaler=256
; 	min frequency is prescaler/Tgate = 2560 Hz
;	Result in F3:F3+1 from 0 (below 2560 Hz) to 65535 (655 kHz)
;	error is +/-1 plus timebase
;

Measure
	CLRB	LED_K	; LED ON
	CLRB	INTCON,T0IF	; Declare "Not yet Over-range"
	CLRF	TMR0		; RESET INTERNAL COUNT (INCLUDING PRESCALER) See page 27 Section 6.0
	CLRF	F3		; Ready to receive 16 bit number
	CLRF	F3+1

	; OPEN GATE
	SetBank 1
	MOVLW	_TRISA & B'11100111'	; initialise data direction, enable RA4 to T0CKI
	MOVWF	TRISA
	Wait_us 99997		; 100MS delay, has to be very precise !!!
	; CLOSE GATE
	MOVLF	TRISA,_TRISA	; dfault, disable RA4 to T0CKI
	SetBank 0

	MOVF	TMR0,W		; GET HIGH BYTE		
	MOVWF	F3		; Copy to Big end of 16 bit result
	JZ	Measure_end	; if  null (F<2560 Hz) exit with F3+1=0

; ici T0CKI=1 pull up, car forc par TRISA,0 = 1 input
; on va clocker " la main" N coups jusqu' avoir previdiseur=0
; l'octet de poids faible est donc 256-N et sera mis dans F3+1

PSCup	SetBank 1
	SETB	OPTION_REG,T0SE	; Clock the prescaler
	NOP
	CLRB	OPTION_REG,T0SE
	SetBank 0

	DECF	F3+1,F		; Decrement the counter
	MOVF	TMR0,W		; Has TMR0 changed?
	XORWF	F3,W		; if unchanged, XOR -> 0
	BZ	PSCup

Measure_end
	SETB	LED_K	; LED OFF
	RETURN			; F3 : F3+1 now holds 16 bit result

;**********************************************************
;
;	Formatted display of BCD work area for Capacitor
;
;	si bcd=0xxxx---		xxx.x nF ou uF
;	si bcd=00xxxx--		xx.xx nF ou uF
;	si bcd=000xxxx-		x.xxx nF ou uF
;	si bcd=0000xxxx		xxx.x pF ou nF
;	si bcd=00000xxx		 xx.x pF ou nF
;	si bcd=000000xx		  x.x pF ou nF

C_disp	movf	R_sign,w	; Sign
	call	LCDPutChar

F_C1	MOVF	bcd+0,W
	ANDLW	0x0F
	BZ	F_C2

	CALL	LCDPutBCD
	call	Swap1
	call	Move1
	CALL	LCDPutDP		; Print DP
	call	Swap2
	goto	F_C3U

;--------------------------------------------------

F_C2	swapf	bcd+1,W
	ANDLW	0x0F
	BZ	F_C3

	CALL	LCDPutBCD
	call	Move1
	CALL	LCDPutDP		; Print DP
	call	Swap2
	call	Move2
	goto	F_C3U		; print nF. includes RETURN

;--------------------------------------------------

F_C3	MOVF	bcd+1,W
	ANDLW	0x0F
	BZ	F_C4

	CALL	LCDPutBCD
	CALL	LCDPutDP		; Print DP
	call	Swap2
	call	Move2
	call	Swap3

F_C3U	MOVLW	Unit_nF-eestart	; nF
	BTFSC	kilo
	 MOVLW	Unit_uF-eestart	; uF
	GOTO	pmsg		; includes RETURN

;--------------------------------------------------

F_C4	SWAPF	bcd+2,W		; Digit1 == 0 ?
	ANDLW	0x0F
	BNZ	NoB1_C

	CALL	LCDPutSpace	; YES PRINT A SPACE

	MOVF	bcd+2,W		; Digit2 == 0 ?
	ANDLW	0x0F
	BNZ	NoB2_C

	CALL	LCDPutSpace	; YES PRINT A SPACE
	GOTO	NoB3_C

NoB1_C	call	Swap2		; 1
NoB2_C	call	Move2		; 2
NoB3_C	call	Swap3		; 3
	CALL	LCDPutDP		; Print DP
	call	Move3		; 4

	movlw	Unit_pF-eestart	; pF
	BTFSC	kilo
	 MOVLW	Unit_nF-eestart	; nF
	goto	pmsg		; includes RETURN

;**********************************************************
;
;	Formatted display of BCD work area for Inductor
;
;	si bcd=0xxxx---		xx.xx mH ou H   -- peu problable qu'on est des Henry ici
;	si bcd=00xxxx--		x.xxx mH ou H
;	si bcd=000xxxx-		xxx.x uH ou mH
;	si bcd=0000xxxx		xx.xx uH ou mH
;	si bcd=00000xxx		 x.xx uH ou mH

L_disp	movf	R_sign,w	; Sign
	call	LCDPutChar

F_L1	MOVF	bcd+0,W
	ANDLW	0x0F
	BZ	F_L2

	CALL	LCDPutBCD
	call	Swap1
	CALL	LCDPutDP		; Print DP
	call	Move1
	call	Swap2
	goto	F_L2U		; Print mH. includes RETURN

;--------------------------------------------------

F_L2	swapf	bcd+1,W
	ANDLW	0x0F
	BZ	F_L3

	CALL	LCDPutBCD
	CALL	LCDPutDP		; Print DP
	call	Move1
	call	Swap2
	call	Move2
	
F_L2U	MOVLW	Unit_mH-eestart	; mH
	BTFSC	kilo
	 MOVLW	Unit_H-eestart	; H

	goto	pmsg		; includes RETURN

;--------------------------------------------------

F_L3	MOVF	bcd+1,W
	ANDLW	0x0F
	BZ	F_L4

	CALL	LCDPutBCD
	call	Swap2
	call	Move2
	CALL	LCDPutDP		; Print DP
	call	Swap3
	goto	F_L4U		; Print uH. includes RETURN

;--------------------------------------------------

F_L4	SWAPF	bcd+2,W		; Digit1 == 0 ?
	ANDLW	0x0F
	BNZ	NoB1_L

	CALL	LCDPutSpace	; YES PRINT A SPACE

	goto	NoB2_L

NoB1_L	call	Swap2		; 1
NoB2_L	call	Move2		; 2
	CALL	LCDPutDP		; Print DP
	call	Swap3		; 3
	call	Move3		; 4

F_L4U	MOVLW	Unit_uH-eestart	; uH
	BTFSC	kilo
	 MOVLW	Unit_mH-eestart	; mH

	goto	pmsg		; includes RETURN

;--------------------------------------------------
;
;	Common subroutine for formatted output
;

Swap0	SWAPF	bcd+0,W		; display bcd+0 high nibble
	goto	LCDPutBCD
Move0	MOVF	bcd+0,W		; display bcd+0 low nibble
	goto	LCDPutBCD
Swap1	SWAPF	bcd+1,W		; display bcd+1 high nibble
	goto	LCDPutBCD
Move1	MOVF	bcd+1,W		; display bcd+1 low nibble
	goto	LCDPutBCD
Swap2	SWAPF	bcd+2,W		; display bcd+2 high nibble
	goto	LCDPutBCD
Move2	MOVF	bcd+2,W		; display bcd+2 low nibble
	goto	LCDPutBCD
Swap3	SWAPF	bcd+3,W		; display bcd+3 high nibble
	goto	LCDPutBCD
Move3	MOVF	bcd+3,W		; display bcd+3 low nibble
	goto	LCDPutBCD

LCDPut5			; print @Wreg et @Wreg+1 ; 16 bits sous la forme xxxx.xx
	MOVWF	FSR		; AARG = @Wreg et @Wreg+1
	CLRF	AARGB0
	MOVF	INDF,W		; Big Byte first
	MOVWF	AARGB1
	INCF	FSR,F
	MOVF	INDF,W		; then little byte
	MOVWF	AARGB2

	CALL	B2BCD		; CONVERT AARGB TO BCD

	CALL	Move1		; display bcd+1 low nibble
	CALL	Swap2		; display bcd+2 high nibble
	CALL	Move2		; display bcd+2 low nibble
	CALL	LCDPutDP
	CALL	Swap3		; display bcd+3 high nibble
	CALL	Move3		; display bcd+3 low nibble
	RETURN

;********************************************************************
;
;	Floating point operations on A,B,C
;

FP24toB24
	CLRF	FPFLAGS
	CALL	INT2424
	IORWF	FPE,f		; W may hold Error (0xff)
	RETURN

B24toFP24
	CLRF	FPFLAGS
	CALL	FLO2424		; 24 bit int -> 24 bit FP
	IORWF	FPE,f		; W may hold Error (0xff)
	RETURN

;add
;	CLRF	FPFLAGS
;	call	FPA24
;	goto	S_fix

subtract
	CLRF	FPFLAGS
	CALL	FPS24		; A = A - B
	GOTO	S_fix

divide
	CLRF	FPFLAGS
	CALL	FPD24		; A = A / B
	GOTO	S_fix

multiply
	CLRF	FPFLAGS
	CALL	FPM24		; A = A * B
;	goto	S_fix

;
;	pop stack after add, subtract, divide & multiply
;	AND Collect ALL Floating Point Errors in FPE

S_fix	IORWF	FPE,f			; W may hold Error (0xff)and FPFLAGS contains the flags

;	CALL	NRM2424			; normalise A
;	IORWF	FPE,f			; W may hold Error (0xff)and FPFLAGS contains the flags

	COPY	CARGB1,BARGB1		; C -> B
	COPY	CARGB0,BARGB0
	COPY	CEXP,BEXP
	RETURN

;
;	Push stack (duplicates TOS)
;

S_push	COPY	BARGB1,CARGB1		; B -> C
	COPY	BARGB0,CARGB0
	COPY	BEXP,CEXP

	COPY	AARGB1,BARGB1		; A -> B
	COPY	AARGB0,BARGB0
	COPY	AEXP,BEXP
	return

;
;	Swap A and B

S_swap	SWAP	AARGB1,BARGB1		; A <-> B
	SWAP	AARGB0,BARGB0
	SWAP	AEXP,BEXP
	return

;********************************************************************
;
;	Calculate Unknown Capacitance OR inductance
;	
;       Output: 24 bit positive integer (scaled) and R_Sign holding sign character
;	right justified in AARGB0, AARGB1, AARGB2
;	also as BCD in bcd:bcd+1:bcd+2:bcd+3
;


C_calc	CALL	divide		; A=(F1/F3-1) / (F1/F2-1) ; B=(F1/F2-1)
	CALL	Get_Ccal	; A=Cref * 10-13 . 10000 = 1000.0pF ; B=(F1/F3-1) / (F1/F2-1) ; C=(F1/F2-1)
	CALL	multiply	; A=Cref * (F1/F3-1) / (F1/F2-1)
	GOTO	LCcalc		; includes return

;--------------------------------------------------------------------

L_calc	CALL	multiply	; A=(F1/F3-1) * (F1/F2-1) ; B=(F1/F2-1)
	CALL	Get_Lcal
	CALL	multiply	; A=K * (F1/F3-1) * (F1/F2-1) 
	CALL	Get_Lscale	; A=K*psf/(4*PI*PI); B=(F1/F3-1) * (F1/F2-1) ; C=(F1/F2-1)
	CALL	multiply	; A=psf/4pi * (F1/F3-1) * (F1/F2-1) 
	CALL	Get_Ccal	; A=Cref * 10-13 ; B=psf/4pi * (F1/F3-1) * (F1/F2-1) 
	CALL	S_swap		; B=Cref * 10-13 ; A=psf/4pi * (F1/F3-1) * (F1/F2-1)
	CALL	divide		; A=psf/4pi * (F1/F3-1) * (F1/F2-1) / Cref
	CALL	Get_F1		; A=F1 ; B=psf/4pi * (F1/F3-1) * (F1/F2-1) / Cref
	CALL	S_push		; A=F1 ; B=F1 ; C=psf/4pi * (F1/F3-1) * (F1/F2-1) / Cref
	CALL	multiply	; A=F1 ; B=psf/4pi * (F1/F3-1) * (F1/F2-1) / Cref
	CALL	S_swap		; B=F1 ; A=psf/4pi * (F1/F3-1) * (F1/F2-1) / Cref
	CALL	divide		; A=psf/4pi * (F1/F3-1) * (F1/F2-1) / Cref / F1
;	GOTO	LCcalc		; includes return

;
;	Handle space or - in front of FP number
;	

LCcalc	MOVLW	0x20		; plus
	BTFSC	AARGB0,7	; test sign
	  MOVLW	0x2d		; minus
	MOVWF	R_sign		; save for later display
	CLRB	AARGB0,7	; make plus anyway


; vrifie le facteur d'chelle
; si AEXP >=0x96 (150) alors le nombre ncessitera plus de 23 bits (>7FFFFF) pour tre reprsent
; 	dans ce cas, on divise par 1000 et on montera l'unit d'un cran
	CLRB	kilo
	CJLT	AEXP,.150,LCcalc2
	CALL	Get_1000
	CALL	S_swap		
	CALL	divide		; A=A/1000
	SETB	kilo
LCcalc2
;
;	Format as raw BCD string in bcd:bcd+1:bcd+2:bcd+3
;
	CALL	FP24toB24	; ARGB FP To INT in 24 bit 2's complement integer right justified in AARGB0, AARGB1, AARGB2
	CALL	B2BCD		; includes return
	RETURN

;********************************************************************
;
;	Calculate (F1/F3)^2-1, leave result on stack
;	Calculate (F1/F2)^2-1, leave result on stack


F1_F3	CALL	Get_F3		; A=F3
	GOTO	$+2
F1_F2	CALL	Get_F2		; A=F2
	CALL	Get_F1		; A=F1 - B=Fx
	CALL	divide		; A=F1/Fx
	CALL	S_push		; A=F1/Fx - B=F1/Fx
	CALL	multiply	; A=(F1/Fx)^2
	CALL	Get_One		; A=1 ; B=(F1/Fx)^2
	CALL	S_swap		; A=(F1/Fx)^2 - B=1
	CALL	subtract	; A=(F1/Fx)^2-1
	RETURN

;********************************************************************
;	Fetch assorted things used for the calculation
;	in floating point format
;

Get_Lscale	; Create FP version of Precomputed 1/(4*PI*PI)* scale factor (uH/100) / Lcal
	CALL	S_push		; make room first
	MOVLF	AEXP,0xAB	; 1e15/4pi = 1e15 * 0.0253303 = 2.53303e+13 = 0xAB384D
	MOVLF	AARGB0,0x38	; 
	MOVLF	AARGB1,0x4D	; 
	RETURN
Get_1000
	CALL	S_push		; make room first
	MOVLF	AEXP,0x88	; 1000 = 887A00
	MOVLF	AARGB0,0x7A	; 
	CLRF	AARGB1
	RETURN
	
Get_One	CALL	S_push		; make room first
	MOVLF	AEXP,0x7F		; 1 = 7F0000
	CLRF	AARGB0
	CLRF	AARGB1
	RETURN

Get_Ccal
	MOVLW	Ccal		; Get integer value
	GOTO	Get_W		; Includes stack push

Get_Lcal
	MOVLW	Lcal		; Get integer value
	GOTO	Get_W		; Includes stack push
	
Get_F1	MOVLW	F1		; Includes stack push
	GOTO	Get_W

Get_F2	MOVLW	F2		; Includes stack push
	GOTO	Get_W

Get_F3	MOVLW	F3		; Includes stack push
;	goto	Get_W

;********************************************************************
;	Copy 16 bit number, pointed to by W, to stack
;	and convert to FP (positive value only)
;	via a 24 bit number in AARGB0,1,2
;	

Get_W	MOVWF	FSR
	CALL	S_push		; make room first A -> B -> C

	CLRF	AEXP
	CLRF	AARGB0

	MOVF	INDF,W		; Big Byte first
	MOVWF	AARGB1
	
	INCF	FSR,F		; then little byte
	MOVF	INDF,W
	MOVWF	AARGB2

	CALL	B24toFP24
	RETURN

;********************************************************************	
;  Read/write EEPROM into "Ccal"

EE_RD	EERead	Ccal0-eestart	; Address to read
	MOVWF	Ccal+0
	EERead	Ccal0-eestart+1	; Address to read
	MOVWF	Ccal+1
	EERead	Lcal0-eestart	; Address to read
	MOVWF	Lcal+0
	EERead	Lcal0-eestart+1	; Address to read
	MOVWF	Lcal+1
	RETURN

EE_WR	MOVF	Ccal+0,W	; Data byte #0
	EEWrite	Ccal0-eestart	; Address to write
	EEWait
	MOVF	Ccal+1,W	; Data byte #1
	EEWrite	Ccal0-eestart+1	; Address to write
	EEWait
	MOVF	Lcal+0,W	; Data byte #0
	EEWrite	Lcal0-eestart	; Address to write
	EEWait
	MOVF	Lcal+1,W	; Data byte #1
	EEWrite	Lcal0-eestart+1	; Address to write
	EEWait
	RETURN

;********************************************************************	

	INCLUDE <FP.asm>

;********************************************************************
;
;	Text Strings (stored in data EEPROM)
;
; 1st line	123456789abcdef0
;		 Calibration
;		 TMR0 = xxxx
;		 F = 123.45 kHz_
;		Depassement
;
; 2nd line	123456789abcdef0
;		 F1 = 123.45 kHz
;		 F2 = 123.45 kHz
;		 C = xxx.xx pF
;		 C = FPerr1 xx
;		 C = FPerr2 xx
;		 L = xxx.xx uH
;		 L = FPerr1 xx
;		 L = FPerr2 xx
;

        ORG 0x2100

eestart
Tintro de	" TMR0 = ",0
F1intro de	" F1 = ",0
F2intro de	" F2 = ",0
Fintro	de	" F = ",0
Cintro	de	" C = ",0
Lintro	de	" L = ",0
;gabarit 16 char"123456789abcdef0"
Calibr  de	" Calibration",0
ovr	de	" Depassement",0
blank	de	"         ",0
FPerr1	de	"FPerr1 ",0
FPerr2	de	"FPerr2 ",0
Unit_uF	de	" uF",0
Unit_nF	de	" nF",0
Unit_pF	de	" pF",0
Unit_H	de	" H ",0
Unit_mH	de	" mH",0
Unit_uH	de	" uH",0
UnitkHz	de	" kHz ",0
Ccal0	de	0x27,0x10		; Initial value = 10000 = 0x2710
Lcal0	de	0x27,0x10

 	END
